# A Closer Look at TabPFN v2: Understanding Its Strengths and Extending Its Capabilities

This paper is submitted to **NeurIPS'25 (Submission 26029)**, under review.

We provide example code to extract embeddings as discussed in our paper. Specifically, using the `kc1` dataset from the `sklearn` interface, you can run `main.py` to obtain both:

* **Vanilla embeddings** from the base TabPFN model, and
* **Enhanced embeddings** proposed in our method.

The script performs the following steps:

1. **Dataset Loading**: Loads the `kc1` dataset from `sklearn.datasets`.
2. **Embedding Extraction**: Runs both the vanilla and enhanced methods to extract embeddings.
3. **Dimensionality Reduction**: Applies PCA to reduce the embeddings to 2D for visualization.
4. **Evaluation**: Trains a logistic regression classifier on the embeddings to evaluate their quality.

To run the example, simply execute:

```bash
python main.py
```

The resulting visualizations and evaluation scores will help you compare the structure and effectiveness of different embeddings.

> 📁 Note: The code in the src/ directory is not developed by us; it originates from https://github.com/PriorLabs/TabPFN. We include it solely as a library dependency and have not made any modifications to it.
